package cn.quantgroup.xyqb.model.session;

import cn.quantgroup.bean.XLoginInfo;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.UserRet;
import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.el.parser.Token;
import org.apache.zookeeper.Login;

/**
 * Created by Miraculous on 2016/12/30.
 */
@Data
public class LoginInfo {

    private String token;
    private UserRet user;
    private LoginContext loginContext;

    @Data
    public static class LoginContext {

        private Long channelId;
        private Long createdFrom;
        private String appChannel;

    }

    public static XLoginInfo getXLoginInfo(LoginInfo loginInfo) {
        if(null == loginInfo) {
            return null;
        }
        String userJson = JSON.toJSONString(loginInfo);
        return JSON.parseObject(userJson, XLoginInfo.class);
    }

}
