package cn.quantgroup.xyqb.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Created by Miraculous on 2017/1/6.
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LoginProperties {

    /**
     * 维度
     * 形如:"app|app名称|平台|应用市场名字"
     * 示例："dimension":"app|shandiandai|IOS|sdd-Appstore"
     */
    private String dimension;
    /**
     * 1-登录
     * 2-注册
     * 3-快捷登录
     * 4-免密登录
     */
    private int action;
    /**
     * 注册渠道号
     */
    private Long channelId = 1L;
    private Long createdFrom = 1L;
    private String appChannel = "";
    private Long merchantId = 1L;
    private String merchantName = "";
    //租户ID
    private Integer tenantId;

    private String stmsUserId;
    private String stmsUserName;


    public LoginProperties(int action, Long createdFrom, Integer tenantId) {
        this.action = action;
        this.createdFrom = createdFrom;
        this.tenantId = tenantId;
    }

    public LoginProperties(String dimension, int action, Long channelId, Long createdFrom, String appChannel, Long merchantId, String merchantName, Integer tenantId) {
        this.dimension = dimension;
        this.action = action;
        this.channelId = channelId;
        this.createdFrom = createdFrom;
        this.appChannel = appChannel;
        this.merchantId = merchantId;
        this.merchantName = merchantName;
        this.tenantId = tenantId;
    }
}
