package cn.quantgroup.xyqb.model.sms;

import lombok.Getter;

/**
 * @author mengfan.feng
 * @time 2015-10-23 13:52
 */
public class SmsConfig {

    /**
     * <pre>
     * 短信平台
     * 0 国都短信平台
     * 1 创蓝短信平台
     * 2 掌中无限短信平台
     * 3 梦网短信平台
     * 4 漫道短信平台
     * </pre>
     */
    @Getter
    public enum SMS {
        // 221.179.180.158/218.241.67.213/211.100.62.140
        GUO_DU("http://123.126.133.188:9007/QxtSms/QxtFirewall", "zxlm", "zxlm001", true),
        CHUANG_LAN("http://222.73.117.158/msg/HttpBatchSendSM", "Zxlm888", "Zxlm888888", true),
        ZHANG_ZHONG_WU_XIAN("http://211.99.191.148/mms/services/info?wsdl", "YCWL-CRM-0100-JOCLMC", "38571163", false),
        MENG_WANG("http://61.130.7.220:8023/MWGate/wmgw.asmx?wsdl", "J50656", "856210", true),
        MAN_DAO("http://sdk.entinfo.cn:8060/webservice.asmx?wsdl", "SDK-BBX-010-23013", "a@2bb0@4", true),;

        /**
         * 请求链接
         */
        private String url;

        /**
         * 平台帐号
         */
        private String account;

        /**
         * 平台密码
         */
        private String password;

        /**
         * 是否激活
         */
        private boolean enabled;

        SMS(String url, String account, String password, boolean enabled) {
            this.url = url;
            this.account = account;
            this.password = password;
            this.enabled = enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }

    /**
     * 短信签名
     */
    public static final String SMS_SIGN = "【信用钱包】";

    /**
     * 短信发送下标
     */
    public static final String SMS_INDEX_KEY = "sms.send-index";
}
