package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import cn.quantgroup.user.UserSysResult;
import cn.quantgroup.user.bean.UserBean;
import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.IpAddr;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.repository.IIpAddrRepository;
import cn.quantgroup.xyqb.repository.IUserRepository;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.ILkbUserService;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import javax.transaction.Transactional;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;

/**
 * Created by Miraculous on 15/7/5.
 */
@Service
public class UserServiceImpl implements IUserService {

    @Autowired
    RedisTemplate<String, String> stringRedisTemplate;

    @Autowired
    private ILkbUserService lkbUserService;

    @Autowired
    private IIpAddrRepository ipAddrRepository;

    @Autowired
    private IUserRepository userRepository;

    @Autowired
    private ISmsService smsService;
    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Value("${usersys.url}")
    private String userSysUrl;
    private IUserSdkService userSdkService;
    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    @Override
    @Cacheable(value = "usercache", key = "'xyqbuser' + #phone", unless = "#result == null", cacheManager = "cacheManager")
    public User findByPhoneInDb(String phone) {
        return userRepository.findByPhoneNo(phone);
    }

    @Override
    public User findByUuidInDb(String uuid) {
        return userRepository.findByUuid(uuid);
    }

    @Override
    public User registerAndReturn(String phoneNo, String password, Long registerFrom) {
        String uuid = lkbUserService.registerApp(phoneNo, password);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());

        UserBean userBean = new UserBean();
        userBean.setUuid(uuid);
        userBean.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
        userBean.setPhoneNo(phoneNo);
        userBean.setCreatedAt(currentTime);
        userBean.setUpdatedAt(currentTime);
        userBean.setRegisteredFrom(registerFrom);

        UserSysResult<XUser> userUserSysResult = userSdkService.saveUser(userBean);
        if (!userUserSysResult.isSuccess()) {
            throw new RuntimeException("保存用户信息出错");
        }
        return Utils.xuser2User(userUserSysResult.getData());
    }


    @Override
    @Cacheable(value = "usercache", key = "'xyqbuser' + #phone", unless = "#result == null", cacheManager = "cacheManager")
    public User findByPhone(String phone) {
        UserSysResult<XUser> user = userSdkService.findUserByPhoneNo(phone);
        if (user.isSuccess()) {
            return Utils.xuser2User(user.getData());
        }
        return null;
    }

    @Override
    public User findByUuid(String uuid) {
        UserSysResult<XUser> user = userSdkService.findUserByUuid(uuid);
        if (user.isSuccess()) {
            return Utils.xuser2User(user.getData());
        }
        return null;
    }

    @Override
    @Transactional(value = Transactional.TxType.REQUIRED)
    public boolean register(String phoneNo, String password, Long registerFrom, String userIp) {

        String uuid = lkbUserService.registerApp(phoneNo, password);
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());

        UserBean userBean = new UserBean();
        userBean.setPhoneNo(phoneNo);
        userBean.setRegisteredFrom(registerFrom);
        userBean.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
        userBean.setUuid(uuid);
        userBean.setCreatedAt(currentTime);
        userBean.setUpdatedAt(currentTime);

        UserSysResult<XUser> userSysResult = userSdkService.saveUser(userBean);
        /**
         * 保存失败,直接返回false
         */
        if(!userSysResult.isSuccess()){
            return false;
        }
        User user =Utils.xuser2User(userSysResult.getData());
        smsService.sendAfterRegister(phoneNo);
        IpAddr ipAddr = new IpAddr();
        ipAddr.setIpAddr(userIp);
        ipAddr.setUserId(user.getId());
        ipAddr.setPhoneNo(phoneNo);
        ipAddr.setLocation("");
        ipAddr.setRegisteredFrom(registerFrom);
        ipAddr.setCreatedAt(currentTime);
        ipAddrRepository.saveAndFlush(ipAddr);

        return exist(phoneNo);
    }

    @Override
    public boolean exist(String phoneNo) {
        UserSysResult<XUser> userUserSysResult = userSdkService.findUserByPhoneNo(phoneNo);
        if (userUserSysResult.isSuccess() && userUserSysResult.getData() != null) {
            return true;
        }
        return false;
    }

    @Override
    @CacheEvict(value = "usercache", key = "'xyqbuser' + #phone", cacheManager = "cacheManager")
    public boolean resetPassword(String phoneNo, String password) {

        UserSysResult<XUser> userSysResult = userSdkService.findUserByPhoneNo(phoneNo);
        if(!userSysResult.isSuccess() || userSysResult.getData() == null){
            throw new RuntimeException("用户[" + phoneNo + "]不存在");
        }
        XUser user = userSysResult.getData();
        user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));

        UserBean userBean = new UserBean();
        userBean.setUuid(user.getUuid());
        userBean.setPassword(user.getPassword());
        userBean.setUpdatedAt(new Timestamp(System.currentTimeMillis()));
        userBean.setCreatedAt(user.getCreatedAt());
        userBean.setRegisteredFrom(user.getRegisteredFrom());
        userBean.setPhoneNo(user.getPhoneNo());
        userSysResult = userSdkService.saveUser(userBean);
        if(userSysResult.isSuccess() && userSysResult.getData() != null){
            stringRedisTemplate.expire("usercache:xyqbuser" + phoneNo, 1L, TimeUnit.MILLISECONDS);
        }
        return StringUtils.equals(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT), user.getPassword());
        /*User user = userRepository.findByPhoneNo(phoneNo);
        if (user == null) {
            throw new RuntimeException("用户[" + phoneNo + "]不存在");
        }
        user.setPassword(PasswordUtil.MD5(password.toLowerCase() + Constants.PASSWORD_SALT));
        user = userRepository.saveAndFlush(user);
        //usercache:xyqbuser18888888888 手动清除
        stringRedisTemplate.expire("usercache:xyqbuser" + phoneNo, 1L, TimeUnit.MILLISECONDS);*/

    }
}
