package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.xyqb.model.sms.SmsConfig;
import cn.quantgroup.xyqb.model.sms.SmsResult;
import cn.quantgroup.xyqb.service.sms.ISmsSender;
import cn.quantgroup.xyqb.thirdparty.mandao.WebService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

import static cn.quantgroup.xyqb.model.sms.SmsConfig.SMS.MAN_DAO;

/**
 * 漫道短信平台
 *
 * @author mengfan.feng
 * @time 2015-11-02 14:28
 */
@Service
public class ManDaoSms implements ISmsSender {

    private static final Map<String, String> ERRORS = ImmutableMap.<String, String>builder()
            .put("-2", "帐号/密码不正确")
            .put("-4", "余额不足支持本次发送")
            .put("-5", "数据格式错误")
            .put("-6", "参数有误")
            .put("-7", "权限受限")
            .put("-8", "流量控制错误")
            .put("-9", "扩展码权限错误")
            .put("-10", "内容长度长")
            .put("-11", "内部数据库错误")
            .put("-12", "序列号状态错误")
            .put("-14", "服务器写文件失败")
            .put("-17", "没有权限")
            .put("-19", "禁止同时使用多个接口地址")
            .put("-20", "相同手机号，相同内容重复提交")
            .put("-22", "Ip鉴权失败")
            .put("-23", "缓存无此序列号信息")
            .put("-601", "序列号为空，参数错误")
            .put("-602", "序列号格式错误，参数错误")
            .put("-603", "密码为空，参数错误")
            .put("-604", "手机号码为空，参数错误")
            .put("-605", "内容为空，参数错误")
            .put("-606", "ext长度大于9，参数错误")
            .put("-607", "参数错误 扩展码非数字 ")
            .put("-608", "参数错误 定时时间非日期格式")
            .put("-609", "rrid长度大于18,参数错误 ")
            .put("-610", "参数错误 rrid非数字")
            .put("-611", "参数错误 内容编码不符合规范")
            .put("-623", "手机个数与内容个数不匹配")
            .put("-624", "扩展个数与手机个数数")
            .put("-625", "定时时间个数与手机个数数不匹配")
            .put("-626", "rrid个数与手机个数数不匹配")
            .build();

    private static final String PWD = PasswordUtil.MD5(MAN_DAO.getAccount() + MAN_DAO.getPassword()).toUpperCase();

    @Override
    public SmsResult send(String phone, String content) {

        String response = new WebService().getWebServiceSoap().mt(MAN_DAO.getAccount(), PWD, phone, content + SmsConfig.SMS_SIGN, "", "", "");

        if (StringUtils.isBlank(response)) {
            return SmsResult.error("漫道短信平台，返回结果为空");
        }

        long rrid = Long.parseLong(response);
        if (rrid > 0) {
            return SmsResult.success();
        }
        return SmsResult.error(ERRORS.get(response));
    }
}
