package cn.quantgroup.xyqb.filter;

import cn.quantgroup.xyqb.service.security.impl.UserDetailsByUuidService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;

@Component
public class Jr58AuthenticatedFilter extends AbstractPreAuthenticatedProcessingFilter {

    @Autowired
    public Jr58AuthenticatedFilter(UserDetailsByUuidService userDetailsService) {
        PreAuthenticatedAuthenticationProvider authProvider = new PreAuthenticatedAuthenticationProvider();
        authProvider.setPreAuthenticatedUserDetailsService(userDetailsService);
        this.setAuthenticationManager(authProvider::authenticate);
    }

    @Override
    protected Object getPreAuthenticatedPrincipal(HttpServletRequest request) {
        String paramValue = request.getParameter("userId");
        return StringUtils.isEmpty(paramValue) ? null : paramValue.toLowerCase();
    }

    @Override
    protected Object getPreAuthenticatedCredentials(HttpServletRequest request) {
        return "dummy credentials";
    }

}
