package cn.quantgroup.xyqb.service.sms;

import cn.quantgroup.xyqb.model.sms.SmsResult;

import java.net.URLEncoder;

/**
 * 短信发送接口
 *
 * @author mengfan.feng
 * @time 2015-07-25 18:47
 */
public interface ISmsSender {

    /**
     * 发送消息<br/>
     *
     * @param phone   手机号
     * @param content 要发送的内容
     * @return ret=true，发送成功<br/>
     * ret=false，msg=错误信息
     */
    SmsResult send(String phone, String content);

    /**
     * URL encode
     *
     * @param content
     * @return
     */
    default String encode(String content, String charset) {
        try {
            return URLEncoder.encode(content, charset);
        } catch (Exception e) {
            return content;
        }
    }
}
