package cn.quantgroup.xyqb.event.jr58;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.event.UserinfoChangedEvent;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class Jr58Notifier implements ApplicationListener<UserinfoChangedEvent> {

    private static final Logger LOGGER = LoggerFactory.getLogger(Jr58Notifier.class);

    @Autowired
    private Jr58DataSender jr58DataSender;

    @Autowired
    private IUserService userService;

    @Override
    public void onApplicationEvent(UserinfoChangedEvent event) {
        LOGGER.info("向58金融同步信息, event:{}", event);

        String uuid = event.getUuid();
        Long channelId = event.getChannelId();
        if (StringUtils.isEmpty(uuid) || channelId == null || channelId != Constants.Channel.JR58) {
            return;
        }

        User user = userService.findByUuid(uuid);
        if (user == null || user.getRegisteredFrom() != Constants.Channel.JR58) {
            return;
        }

        jr58DataSender.sendUserinfo(uuid);
    }
}
