package cn.quantgroup.xyqb.entity;

import javax.persistence.*;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by Miraculous on 15/7/21.
 */
@Entity
@Table(name = "bank_card", uniqueConstraints = @UniqueConstraint(columnNames = "card_no"))
public class BankCard implements Serializable {

    private static final long serialVersionUID = -1L;
    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @NotNull
    @Column(name = "card_no")
    private String cardNo;

    // 持卡人
    @Column(name = "card_holder_name")
    private String cardHolderName;

    @Column(name = "phone_no")
    private String phoneNo;

    @Column(name = "bank_name")
    private String bankName;

    // 支行行号
    @Column(name = "branch_no")
    private String branchNo;

    @Column(name = "branch_name")
    private String branchName;

    @Column(name = "has_already_binded")
    private Boolean hasAlreadyBinded;

    @Column(name = "city")
    private String city;

    @Column(name = "province")
    private String province;

    @Column(name = "created_at")
    private Timestamp createdAt;

    @Column(name = "updated_at")
    private Timestamp updatedAt;

    public BankCard() {
    }

    public String getBankName() {
        return bankName;
    }

    public void setBankName(String bankName) {
        this.bankName = bankName;
    }

    public String getBranchName() {
        return branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public String getBranchNo() {
        return branchNo;
    }

    public void setBranchNo(String branchNo) {
        this.branchNo = branchNo;
    }

    public String getCardHolderName() {
        return cardHolderName;
    }

    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    public String getCardNo() {
        return cardNo;
    }

    public void setCardNo(String cardNo) {
        this.cardNo = cardNo;
    }

    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Boolean getHasAlreadyBinded() {
        return hasAlreadyBinded;
    }

    public void setHasAlreadyBinded(Boolean hasAlreadyBinded) {
        this.hasAlreadyBinded = hasAlreadyBinded;
    }

    public String getCity() {
        return city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getProvince() {
        return province;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    @Override
    public String toString() {
        return "BankCard{" +
                "bankName='" + bankName + '\'' +
                ", id=" + id +
                ", userId=" + userId +
                ", cardNo='" + cardNo + '\'' +
                ", cardHolderName='" + cardHolderName + '\'' +
                ", phoneNo='" + phoneNo + '\'' +
                ", branchNo='" + branchNo + '\'' +
                ", branchName='" + branchName + '\'' +
                ", hasAlreadyBinded=" + hasAlreadyBinded +
                ", city='" + city + '\'' +
                ", province='" + province + '\'' +
                ", createdAt=" + createdAt +
                ", updatedAt=" + updatedAt +
                '}';
    }
}
