package cn.quantgroup.xyqb;

import com.google.gson.Gson;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface Constants {

    // zero fill with 4 chars...
    String ZERO_FILL_TEMPLATE = "%04d";

    String PASSWORD_SALT = "_lkb";

    String IMAGE_CAPTCHA_KEY = "img_captcha:";
    String REDIS_CAPTCHA_KEY = "auth:";
    String REDIS_CAPTCHA_KEY_PATTERN = REDIS_CAPTCHA_KEY + IMAGE_CAPTCHA_KEY + "*";

    String CONFIG_CAPTCHA = "cfg_captcha_%";
    // app 后端白名单
    String CONFIG_CAPTCHA_WHITEIP_LIST = "cfg_captcha_white_ip_appbackend";
    // 每个 IP 每分钟 captcha 限制
    String CONFIG_CAPTCHA_PERIP_PERMIN = "cfg_captcha_per_ip_per_min";
    // 是否启用万能验证码
    String CONFIG_CAPTCHA_MAGIC_CODE_ENABLED = "cfg_captcha_magic_code_enabled";

    Gson GSON = new Gson();

    String REDIS_PREFIX_VERIFICATION_CODE = "verificationCode_";

    /**
     * redis中token的key值前缀
     */
    String SESSION_PREFIX = "spring:session:sessions:";

    interface Sms {
        String VERIFICATION_CODE = "尊敬的用户，您本次的验证码为：%s，有效期10分钟。"; // 随机验证码
        String BINDCARD_SMS = "用户您好，您已绑卡成功，将会在1-5个工作日内收到借款，请耐心等待。如有疑问，请致电400-002-0061，感谢您对我们的支持";//绑卡成功后的短信文案
        String REPAY_SMS = "用户您好，您在信用钱包的本期账单已还款成功，保持良好的信用可升级为VIP用户，享更多特权，感谢您对信用钱包的支持";
    }

    interface Jr58 {
        int ERROR_PHONE_NUMBER = 20007; // 手机号码格式不正确
        int ERROR_ID_CARD = 20009; // 身份证格式不正确
        int ERROR_ACCOUNT = 20010; // 授权账号为空
        int ERROR_AUTH_TYPE = 20011; // 授权类型为空
    }

    interface Channel {
        long LKB = 1;    // 量化派
        long JR58 = 175;    // 58金融
        String LKB_CODE = "0002";    // 量化派channnel_code
    }
}
