package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.xyqb.model.sms.SmsResult;
import cn.quantgroup.xyqb.service.sms.ISmsSender;
import cn.quantgroup.xyqb.thirdparty.mengwang.Wmgw;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

import static cn.quantgroup.xyqb.model.sms.SmsConfig.SMS.MENG_WANG;

/**
 * <pre>
 * 梦网短信平台
 * 错误返回：
 * -1 	参数为空。信息、电话号码等有空指针，登陆失败
 * -12	有异常电话号码
 * -13  电话号码个数与实际个数不相等
 * -14	实际号码个数超过100
 * -999	web服务器内部错误
 * -10001   用户登陆不成功(帐号不存在/停用/密码错误)
 * -10003	用户余额不足
 * -10011	信息内容超长
 * -10029	此用户没有权限从此通道发送信息(用户没有绑定该性质的通道，比如：用户发了小灵通的号码)
 * -10030	不能发送移动号码
 * -10031	手机号码(段)非法
 * -10057	IP受限
 * -10056	连接数超限
 * </pre>
 *
 * @author mengfan.feng
 * @time 2015-10-22 16:25
 */
@Service
public class MengWangSms implements ISmsSender {

    private static final Map<String, String> ERRORS = ImmutableMap.<String, String>builder()
            .put("-1", "参数为空")
            .put("-12", "有异常电话号码")
            .put("-13", "电话号码个数与实际个数不相等")
            .put("-14", "实际号码个数超过100")
            .put("-999", "web服务器内部错误")
            .put("-10001", "用户登陆不成功(帐号不存在/停用/密码错误)")
            .put("-10003", "用户余额不足")
            .put("-10011", "信息内容超长")
            .put("-10029", "此用户没有权限从此通道发送信息")
            .put("-10030", "不能发送移动号码")
            .put("-10031", "手机号码(段)非法")
            .put("-10057", "IP受限")
            .put("-10056", "连接数超限")
            .build();

    @Override
    public SmsResult send(String phone, String content) {

        String response = new Wmgw().getWmgwSoap().mongateSendSubmit(MENG_WANG.getAccount(), MENG_WANG.getPassword(), phone, content, 1, "*", "0");

        if (StringUtils.isBlank(response)) {
            return SmsResult.error("梦网短信平台，返回结果为空");
        }

        if (response.replaceFirst("-", "").length() > 10) {
            return SmsResult.success();
        }
        return SmsResult.error(ERRORS.get(response));
    }
}
