package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.xyqb.model.sms.GuoDuResult;
import cn.quantgroup.xyqb.model.sms.SmsConfig;
import cn.quantgroup.xyqb.model.sms.SmsResult;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.sms.ISmsSender;
import cn.quantgroup.xyqb.util.XmlUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

import static cn.quantgroup.xyqb.model.sms.SmsConfig.SMS.GUO_DU;

/**
 * <pre>
 * 国都短信平台
 * 状态码	说明
 * 01	批量短信提交成功
 * 02	IP限制
 * 03	单条短信提交成功
 * 04	用户名错误
 * 05	密码错误
 * 07	发送时间错误
 * 08	信息内容为黑内容
 * 09	该用户的该内容 受同天内，内容不能重复发 限制
 * 10	扩展号错误
 * 97	短信参数有误
 * 11	余额不足
 * -1	程序异常
 * </pre>
 *
 * @author mengfan.feng
 * @time 2015-09-21 11:25
 */
@Service
public class GuoDuSms implements ISmsSender {

    private static final Map<String, String> ERRORS = ImmutableMap.<String, String>builder()
            .put("01", "批量短信提交成功")
            .put("02", "IP限制")
            .put("03", "单条短信提交成功")
            .put("04", "用户名错误")
            .put("05", "密码错误")
            .put("07", "发送时间错误")
            .put("08", "信息内容为黑内容")
            .put("09", "该用户的该内容 受同天内，内容不能重复发 限制")
            .put("10", "扩展号错误")
            .put("97", "短信参数有误")
            .put("11", "余额不足")
            .put("-1", "程序异常")
            .build();

    @Autowired
    private IHttpService httpService;

    @Override
    public SmsResult send(String phone, String content) {

        Map<String, String> parameters = ImmutableMap.<String, String>builder()
                .put("OperID", GUO_DU.getAccount())
                .put("OperPass", GUO_DU.getPassword())
                .put("SendTime", "")
                .put("ValidTime", "")
                .put("AppendID", "")
                .put("DesMobile", phone)
                .put("Content", encode(SmsConfig.SMS_SIGN + content, "GBK"))
                .put("ContentType", "8")
                .build();

        String response = httpService.get(GUO_DU.getUrl() + "?" + Joiner.on("&").withKeyValueSeparator("=").join(parameters));

        if (StringUtils.isBlank(response)) {
            return SmsResult.error("国都短信平台，返回结果为空");
        }

        GuoDuResult result = XmlUtil.obj(response, GuoDuResult.class);
        String code = result.getCode();

        if ("03".equals(code) || "01".equals(code)) {
            return SmsResult.success();
        }
        return SmsResult.error(ERRORS.get(code));
    }
}
