package cn.quantgroup.xyqb.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by Miraculous on 15/7/4.
 */
@Entity
@Table(name = "user", uniqueConstraints = @UniqueConstraint(columnNames = "phone_no"))
public class User implements Serializable {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    //手机号
    @Column(name = "phone_no")
    private String phoneNo;

    //uuid
    @Column(name = "password")
    private String password;


    //第一次用户来源 channel_id
    @Column(name = "registered_from")
    private Long registeredFrom;

    //uuid
    @Column(name = "uuid")
    private String uuid;

    @Column(name = "enable")
    private Boolean enable;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    //上一次修改时间
    @Column(name = "updated_at")
    private Timestamp updatedAt;

    public Boolean isEnable() {
        return enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Long getRegisteredFrom() {
        return registeredFrom;
    }

    public void setRegisteredFrom(Long registeredFrom) {
        this.registeredFrom = registeredFrom;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public Timestamp getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(Timestamp updatedAt) {
        this.updatedAt = updatedAt;
    }

}
