package cn.quantgroup.xyqb.entity;

import javax.persistence.*;
import java.sql.Timestamp;

/**
 * Created by FrankChow on 15/11/4.
 */
@Entity
@Table(name = "ip_addr", uniqueConstraints = @UniqueConstraint(columnNames = "phone_no"))
public class IpAddr {

    private static final long serialVersionUID = -1L;

    @Id
    @Column(name = "id")
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column(name = "user_id")
    private Long userId;

    @Column(name = "phone_no")
    private String phoneNo;

    //第一次用户来源 channel_id
    @Column(name = "registered_from")
    private Long registeredFrom;

    @Column(name = "ip_addr")
    private String ipAddr;

    @Column(name = "location")
    private String location;

    @Column(name = "location_id")
    private int locationId;

    @Column(name = "is_processed")
    private Boolean isProcessed = false;

    //创建时间
    @Column(name = "created_at")
    private Timestamp createdAt;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getPhoneNo() {
        return phoneNo;
    }

    public void setPhoneNo(String phoneNo) {
        this.phoneNo = phoneNo;
    }

    public String getIpAddr() {
        return ipAddr;
    }

    public void setIpAddr(String ipAddr) {
        this.ipAddr = ipAddr;
    }

    public String getLocation() {
        return location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int getLocationId() {
        return locationId;
    }

    public void setLocationId(int locationId) {
        this.locationId = locationId;
    }

    public Boolean getIsProcessed() {
        return isProcessed;
    }

    public void setIsProcessed(Boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    public Timestamp getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public Long getRegisteredFrom() {
        return registeredFrom;
    }

    public void setRegisteredFrom(Long registeredFrom) {
        this.registeredFrom = registeredFrom;
    }
}
