package cn.quantgroup.xyqb.service.security.impl;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.exception.UserNotExistException;
import cn.quantgroup.xyqb.exception.VerificationCodeErrorException;
import cn.quantgroup.xyqb.model.AppSmsUserParam;
import cn.quantgroup.xyqb.model.AuthenticationUserDetail;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.ValidationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.stereotype.Service;

import java.util.Random;

/**
 * @author xiaoguang.xu
 * @time 2016-03-16 13:00
 */
@Service
public class UserDetailsBySmsService implements AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserDetailsBySmsService.class);

    @Autowired
    private IUserService userService;

    @Override
    public UserDetails loadUserDetails(PreAuthenticatedAuthenticationToken token) throws UsernameNotFoundException {
        AppSmsUserParam param = (AppSmsUserParam) token.getPrincipal();
        if (param.getPhoneNo() == null) {
            throw new UserNotExistException("用户未找到");
        }
        if (null != param.getErrorMsg()) {
            throw new VerificationCodeErrorException(param.getErrorMsg());
        }
        User user = userService.findByPhone(param.getPhoneNo());
        if (user == null) {
            user = registerFastWhenLogin(param.getPhoneNo(), param.getChannelId(), param.getRegisterFrom(), param.getAppChannel());
            if (user == null) {
                throw new UserNotExistException("用户未找到");
            }
        }
        return new AuthenticationUserDetail(user);
    }

    public User registerFastWhenLogin(String phoneNo, Long channelId, Long registerFrom, String appChannel) {
        String password = genRandomPwd();
        LOGGER.info("用户快速注册, phoneNo:{}, verificationCode:{}, channelId:{}, registerFrom:{},appChannel:{}", phoneNo, channelId, registerFrom, appChannel);
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            LOGGER.info("用户快速注册失败，手机号错误, registerFrom:{}, phoneNo:{}", registerFrom, phoneNo);
            throw new UserNotExistException("手机号错误");
        }
        if (null == registerFrom) {
            registerFrom = 1L;
        }
        LOGGER.info("用户快速注册成功, registerFrom:{}, phoneNo:{}", registerFrom, phoneNo);

        return userService.registerAndReturn(phoneNo, password, registerFrom);

    }


    private static final char[] PWD_BASE = {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k',
            'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w',
            'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};

    private String genRandomPwd() {
        int pwdMax = PWD_BASE.length;
        int i; // 生成的随机数
        int count = 0; // 生成的密码的长度
        StringBuffer pwd = new StringBuffer();
        Random r = new Random();
        while (count < 15) {
            i = Math.abs(r.nextInt(pwdMax)); // 生成的数最大为36-1
            if (i >= 0 && i < PWD_BASE.length) {
                pwd.append(PWD_BASE[i]);
                count++;
            }
        }
        return pwd.toString();
    }

}
