package cn.quantgroup.xyqb.entity;

import lombok.Data;
import org.apache.commons.lang.StringUtils;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import java.io.Serializable;
import java.sql.Timestamp;

/**
 * Created by 11 on 2016/12/20.
 */
@Data
public class UserRet implements Serializable{
    private static final long serialVersionUID = -1L;

    private Long id;

    //手机号
    private String phoneNo;

    //uuid
    private String password;

    //第一次用户来源 channel_id
    private Long registeredFrom;

    //uuid
    private String uuid;

    private Boolean enable;

    //创建时间
    private Long createdAt;

    //上一次修改时间
    private Long updatedAt;

    public static UserRet getUserRet(User user){
        Long createTimeStamp = user.getCreatedAt().getTime();
        Long updateTimeStamp = user.getUpdatedAt().getTime();
        UserRet userRet = new UserRet();
        userRet.setId(user.getId());
        userRet.setPhoneNo(user.getPhoneNo());
        userRet.setEnable(true);
        userRet.setPassword(StringUtils.defaultIfEmpty(user.getPassword(), ""));
        userRet.setRegisteredFrom(user.getRegisteredFrom());
        userRet.setUuid(user.getUuid());
        userRet.setCreatedAt(createTimeStamp);
        userRet.setUpdatedAt(updateTimeStamp);
        return userRet;
    }
}
