package cn.quantgroup.xyqb.controller.external.user;

import cn.quantgroup.user.IUserSdkService;
import cn.quantgroup.user.UserSdkServiceFactory;
import cn.quantgroup.user.UserSysResult;
import cn.quantgroup.user.bean.UserDetailSaveBean;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserModel;
import cn.quantgroup.xyqb.service.user.IUserService;
import cn.quantgroup.xyqb.util.Utils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.PostConstruct;

/**
 * 同步用户数据，第三方模块访问时
 * Created by Miraculous on 15/12/29.
 */
@RestController
@RequestMapping("/api/sync")
public class SyncUserController {

    @Autowired
    private IUserService userService;
    /*@Autowired
    private IUserDetailRepository userDetailRepository;*/

    @Autowired
    @Qualifier("httpClient")
    private CloseableHttpClient httpClient;
    @Value("${usersys.url}")
    private String userSysUrl;
    private IUserSdkService userSdkService;
    @PostConstruct
    private void init() {
        userSdkService = UserSdkServiceFactory.generateSDKService(userSysUrl, httpClient);
    }

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> stringRedisTemplate;

    @RequestMapping("/user")
    public JsonResult fetchUser(String key, String phoneNo) {
        if (StringUtils.isEmpty(key) || !"abc1234".equals(key)) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        if (StringUtils.isEmpty(phoneNo)) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        User user = userService.findByPhone(phoneNo);
        if (null == user) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        UserSysResult<XUserDetail> userSysResult = userSdkService.findUserDetailByUserId(user.getId());
//        if(!userSysResult.isSuccess() || userSysResult.getData() == null){
//            return JsonResult.buildErrorStateResult(null, null);
//        }
        UserModel userModel = new UserModel(user, Utils.xuserDetail2UserDetail(userSysResult.getData()));
        return JsonResult.buildSuccessResult(null, userModel);


        /*UserDetail detail = userDetailRepository.findByUserId(user.getId());
        if (null == detail) {
            // FIXME: 16/4/15 前期不对身份证强制要求.后期对修改
//            return JsonResult.buildErrorStateResult(null, null);
        }
        UserModel userModel = new UserModel(user, detail);
        return JsonResult.buildSuccessResult(null, userModel);*/
    }

    @RequestMapping("/save_detail")
    public JsonResult saveUserDetail(String key, UserDetail userDetail) {
        if (StringUtils.isEmpty(key) || !"abc1234".equals(key)) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        String phoneNo = userDetail.getPhoneNo();
        User user = userService.findByPhone(phoneNo);
        if (null == user) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        userDetail.setId(null);
        userDetail.setUserId(user.getId());

        //修改代码
        UserDetailSaveBean saveBean = new UserDetailSaveBean();
        saveBean.setName(userDetail.getName());
        saveBean.setEmail(userDetail.getEmail());
        saveBean.setUserId(user.getId());
        saveBean.setPhoneNo(userDetail.getPhoneNo());
        saveBean.setIdNo(userDetail.getIdNo());
        userSdkService.saveUserDetail(saveBean);
        return JsonResult.buildSuccessResult(null, null);


        /*userDetailRepository.saveAndFlush(userDetail);
        return JsonResult.buildSuccessResult(null, null);*/
    }

    @RequestMapping("/user_uuid")
    public JsonResult fetchUserByUuid(String key, String uuid) {
        if (StringUtils.isEmpty(key) || !"abc1234".equals(key)) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        if (StringUtils.isEmpty(uuid)) {
            return JsonResult.buildErrorStateResult(null, null);
        }
        User user = userService.findByUuid(uuid);
        if (null == user) {
            return JsonResult.buildErrorStateResult(null, null);
        }


        UserSysResult<XUserDetail> userSysResult = userSdkService.findUserDetailByUserId(user.getId());
        if(!userSysResult.isSuccess() || userSysResult.getData() == null){

        }
        UserModel userModel = new UserModel(user, Utils.xuserDetail2UserDetail(userSysResult.getData()));
        return JsonResult.buildSuccessResult(null, userModel);


        /*UserDetail detail = userDetailRepository.findByUserId(user.getId());
        if (null == detail) {
            // FIXME: 16/4/15 前期不对身份证强制要求.后期对修改
//            return JsonResult.buildErrorStateResult(null, null);
        }
        UserModel userModel = new UserModel(user, detail);
        return JsonResult.buildSuccessResult(null, userModel);*/
    }
}
