package cn.quantgroup.xyqb.util;

import cn.quantgroup.user.retbean.XUser;
import cn.quantgroup.user.retbean.XUserDetail;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.entity.UserDetail;
import cn.quantgroup.xyqb.model.Gender;
import cn.quantgroup.xyqb.model.IdType;

import java.util.Map;

/**
 * @author mengfan.feng
 */
public class Utils {

    public static String safeMap2Str(Map<String, String> info) {
        if (null == info) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        info.forEach((key, value) -> {
            if ("password".equals(key)) {
                return;
            }
            builder.append(key);
            builder.append("=");
            builder.append(value);
            builder.append(",");
        });
        builder.append("}");
        return builder.toString();
    }

    public static User xuser2User(XUser xuser) {
        if (xuser == null) {
            return null;
        }
        User user = new User();
        user.setId(xuser.getId());
        user.setUpdatedAt(xuser.getUpdatedAt());
        user.setCreatedAt(xuser.getCreatedAt());
        user.setPassword(xuser.getPassword());
        user.setRegisteredFrom(xuser.getRegisteredFrom());
        user.setUuid(xuser.getUuid());
        user.setEnable(xuser.getEnable());
        user.setPhoneNo(xuser.getPhoneNo());
        return user;
    }

    public static UserDetail xuserDetail2UserDetail(XUserDetail xuserDetail) {
        if (xuserDetail == null) {
            return null;
        }
        UserDetail userDetail = new UserDetail();
        userDetail.setPhoneNo(xuserDetail.getPhoneNo());
        userDetail.setUpdatedAt(xuserDetail.getUpdatedAt());
        userDetail.setCreatedAt(xuserDetail.getCreatedAt());
        userDetail.setEmail(xuserDetail.getEmail());
        Gender gender;
        if (xuserDetail.getGender() == null) {
            gender = Gender.UNKNOWN;
        } else {
            gender = Gender.valueOf(xuserDetail.getGender().name());
        }
        userDetail.setGender(gender);
        userDetail.setId(xuserDetail.getId());
        userDetail.setIdNo(xuserDetail.getIdNo());
        IdType idType;
        if (xuserDetail.getIdType() == null) {
            idType = IdType.ID_CARD;
        } else {
            idType = IdType.valueOf(xuserDetail.getIdType().name());
        }
        userDetail.setIdType(idType);
        userDetail.setIsAuthenticated(xuserDetail.getIsAuthenticated());
        userDetail.setQq(xuserDetail.getQq());
        userDetail.setUserId(xuserDetail.getUserId());
        userDetail.setName(xuserDetail.getName());
        return userDetail;
    }

}
