package cn.quantgroup.xyqb.service.v2;

import cn.quantgroup.xyqb.controller.req.v2.LoginReq;
import cn.quantgroup.xyqb.entity.UserTag;
import cn.quantgroup.xyqb.event.UserLoginEvent;
import cn.quantgroup.xyqb.model.LoginBean;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.v2.login.BaseLoginParam;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class LoginContext {
    private final Map<Integer, LoginStrategy> loginStrategyMap = new HashMap<>();
    private final ApplicationEventPublisher applicationEventPublisher;

    public LoginContext(List<LoginStrategy> loginStrategies, ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
        loginStrategies.forEach(i -> loginStrategyMap.put(i.getType(), i));
    }

    public LoginBean login(LoginReq loginReq) {
        //第一步、校验参数
        LoginStrategy loginStrategy = loginStrategyMap.get(loginReq.getType());
        BaseLoginParam loginParam = loginStrategy.checkParam(loginReq);


        //第二步、执行登录操作
        LoginBean loginBean = loginStrategy.login(loginParam);

        //第三步、发送登录成功消息
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();

        UserTag userTag = UserTag.builder().userId(loginBean.getUserId()).registeredFrom(sessionStruct.getRegisteredFrom()).tenantId(sessionStruct.getTenantId()).build();
        String geetestId = null;
        if (StringUtils.isNotEmpty(sessionStruct.getGeetestId())) {
            geetestId = sessionStruct.getGeetestId();
        }

        UserLoginEvent userLoginEvent = new UserLoginEvent(this, userTag, geetestId);
        applicationEventPublisher.publishEvent(userLoginEvent);

        return loginBean;
    }
}
