package cn.quantgroup.xyqb.session;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.model.session.SessionValue;
import cn.quantgroup.xyqb.util.IpUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * Created by Miraculous on 2016/12/29.
 */
@Slf4j
public class XyqbSessionContextHolder {

    private static final ThreadLocal<SessionStruct> threadSession = new ThreadLocal<>();
    private static RedisTemplate<String, String> redisTemplate = null;

    public static void setRedisTemplate(RedisTemplate<String, String> redisTemplate) {
        XyqbSessionContextHolder.redisTemplate = redisTemplate;
    }

    public static SessionStruct getXSession() {
        SessionStruct sessionStruct;
        if (threadSession.get() != null) {
            sessionStruct = threadSession.get();
        } else {
            sessionStruct = getXSessionFromRedis();
            threadSession.set(sessionStruct);
        }
        return sessionStruct;
    }

    public static void initXSession() {
        SessionStruct sessionStruct;
        if (threadSession.get() == null) {

            sessionStruct = new SessionStruct();
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            String tenantId = request.getHeader(Constants.X_AUTH_TENANT);
            String registered_from = request.getHeader(Constants.X_AUTH_FROM);
            String ip = IpUtil.getRemoteIP(request);
            sessionStruct.setTenantId(Integer.valueOf(tenantId));
            sessionStruct.setRegisteredFrom(Long.valueOf(registered_from));
            sessionStruct.setIp(ip);

            //如果是极验，那赋值
            if (request.getHeader(Constants.X_BEHAVIOR_TYPE) != null && "1".equals(request.getHeader(Constants.X_BEHAVIOR_TYPE))) {
                String geetestId = request.getHeader(Constants.X_BEHAVIOR_ID);
                sessionStruct.setGeetestId(geetestId);
            }

            threadSession.set(sessionStruct);
        }
    }

    public static SessionStruct getXSessionFromRedis() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        String token = request.getHeader(Constants.X_AUTH_TOKEN);
        return getXSessionFromRedis(token);
    }

    public static String getXSessionFromTenantRedis() {
        HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
        return request.getHeader(Constants.X_AUTH_TENANT);
    }

    public static SessionStruct getXSessionFromRedis(String token) {
        String linkToken = Constants.Session.USER_SESSION_CACHE + token;
        String result = redisTemplate.opsForValue().get(linkToken);
        if (StringUtils.isEmpty(result)) {
            log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] session data 未找到：Tokekn:{},linkTokekn:{},sessionValue:{}", token, linkToken, result);
            return null;
        }
        try {
            SessionValue values = JSON.parseObject(result, SessionValue.class);
            if (values == null) {
                log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] session data 序列化失败：token:{},linkTokekn:{},sessionValue:{}", token, linkToken, result);
                return null;
            }
            SessionStruct sessionStruct = new SessionStruct();
            sessionStruct.setSid(token);
            sessionStruct.setValues(values);
            sessionStruct.setExpire(redisTemplate.getExpire(Constants.Session.USER_SESSION_CACHE + token));
            return sessionStruct;
        } catch (Exception e) {
            log.warn("[XyqbSessionContextHolder][getXSessionFromRedis] 序列化SessionValue出错：Tokekn:{},linkTokekn:{},sessionValue:{}", token, linkToken, result, e);
            return null;
        }
    }

    public static void releaseSession() {
        threadSession.remove();
    }
}
