package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.xyqb.entity.User;

import java.util.List;
import java.util.Map;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IUserService {

  User findByPhoneWithCache(String phone);

  User findByUuidWithCache(String uuid);

  boolean register(String phoneNo, String password, Long registerFrom, String userIp, Long channelId);

  User registerAndReturn(String phoneNo, String password, Long registerFrom);

  boolean exist(String phoneNo);

  boolean resetPassword(String phoneNo, String password);

  User findByPhoneInDb(String phone);

  User findByUuidInDb(String uuid);

  Map<Long, String> findPhoneByIdsInDb(List<Long> userIds);

  User saveUser(User user);

  User findById(Long userId);

  boolean register(String phoneNo, String password, Long registerFrom, String ip, Long channelId, Long btRegisterChannelId,String dimension);
  List<User> findByPhones(List<String> phones);

  User registerAndReturn(String phoneNo, String password, Long registerFrom, Long btRegisterChannelId);

  /**
   * 用户、联系人、地址信息注册
   * @param registeredFrom
   * @param channelId
   * @param phoneNo
   * @param name
   * @param idNo
   * @param provinceCode
   * @param province
   * @param cityCode
   * @param city
   * @param districtCode
   * @param district
   * @param address
   * @param contacts
   * @return
   */
  User registerAndReturn( Long registeredFrom,
                          Long channelId,
                          String phoneNo,
                          String name,
                          String idNo,
                          String provinceCode,
                          String province,
                          String cityCode,
                          String city,
                          String districtCode,
                          String district,
                          String address,
                          String contacts);

  List<User> findRegisterUserByTime(String beginTime,String endTime);
}
