package cn.quantgroup.xyqb.xxlJob;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.config.data.WechatConfiguration;
import cn.quantgroup.xyqb.remote.WechatRemoteService;
import com.xxl.job.core.handler.annotation.XxlJob;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import java.util.Map;

@Component
@Slf4j
public class WechatTokenReloadJobHandler {
    private final WechatConfiguration configuration;

    private final WechatRemoteService wechatRemoteService;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    public WechatTokenReloadJobHandler(WechatConfiguration configuration, WechatRemoteService wechatRemoteService) {
        this.configuration = configuration;
        this.wechatRemoteService = wechatRemoteService;
    }

    /**
     * 目前是7200秒之内的值。定时任务需要小于2小时
     */
    @XxlJob(value = "wechatTokenReloadJobHandler")
    public void execute() {

        configuration.getList().stream().filter(i->i.getType()==0).forEach(i->{
           Map<String,String > result = wechatRemoteService.getAccessToken(i.getAppId(),i.getAppSecret());
            if (result.containsKey("errcode")) {
                log.error("微信获取token失败:{}", i.getAppId());
            } else {
                redisTemplate.opsForValue().set(Constants.WECHAT_ACCESS_TOKEN_REDIS+i.getTenantId()+":"+i.getAppId(),result.get("access_token"));
            }
        });

    }
}
