package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/api/v2/wechat")
public class WechatApiV2Controller {
    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @GetMapping("/accessToken")
    public JsonResult<String> token(String appId) {
        SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();
        String accessToken = redisTemplate.opsForValue().get(Constants.WECHAT_ACCESS_TOKEN_REDIS + sessionStruct.getTenantId() + ":" + appId);

        return JsonResult.buildSuccessResultGeneric(accessToken);
    }
}
