package cn.quantgroup.xyqb.service.user;

import cn.quantgroup.user.enums.Relation;
import cn.quantgroup.xyqb.entity.Contact;

import java.util.List;

/**
 * Created by Miraculous on 2017/1/3.
 */
public interface IContactService {
  List<Contact> findByUserId(Long userId);

  /**
   * 清除非法联系人记录
   * @param contacts - 包含待清除记录的联系人列表
   * @return 只包含合法联系人记录的列表
   */
  List<Contact> trim(List<Contact> contacts);

  Contact findById(Long id);

  /**
   * 批量保存用户联系人
   * 如果已存在联系人，则覆盖更新
   * @param userId - 用户主键
   * @param contacts - 联系人列表
   * @return
   */
  List<Contact> save(Long userId, List<Contact> contacts);
  Contact save(Contact contact);

  Contact saveContact(String name, String phoneNo, Relation relation, Contact contact);
}
