package demo;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.controller.internal.sms.SmsController;
import cn.quantgroup.xyqb.controller.internal.user.UserController;
import cn.quantgroup.xyqb.model.JsonResult;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = Bootstrap.class)
@WebAppConfiguration
public class DemoApplicationTests {

  @Autowired
  private UserController userController;

  @Autowired
  private SmsController smsController;

  private String smsRegCode = "";

  @Test
  public void sendRegCode() {
    JsonResult jsonResult = smsController.sendRegistCode("18611428880", null);
    System.out.print(jsonResult.getMsg());
    Assert.assertEquals(jsonResult.getCode(), "0000");
    Assert.assertEquals(jsonResult.getBusinessCode(), "0000");

  }

  @Test
  public void registerFast() {
    JsonResult jsonResult = userController.registerFast("18611428880", "000000", null, null, "");
    Assert.assertEquals(jsonResult.getCode(), "0000");
  }

  @Test
  public void sendLoginCode() {
    JsonResult jsonResult = smsController.sendLoginCode("18611428880", null);
    Assert.assertEquals(jsonResult.getCode(), "0000");
  }

  @Test
  public void loginFast() {

  }


}
