package cn.quantgroup.xyqb.interceptors;

import cn.quantgroup.xyqb.util.IPUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.regex.Pattern;

/**
 * Created by Administrator on 2017/5/9.
 */
public class IPWhiteListInterceptor implements HandlerInterceptor {

    private Integer isDebug;

    private static final Logger LOGGER = LoggerFactory.getLogger(IPWhiteListInterceptor.class);

    private static final String patternStr = "172.*";
    private static final Pattern pattern = Pattern.compile(patternStr);

    public IPWhiteListInterceptor(Integer isDebug) {
        this.isDebug = isDebug;
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if(isDebug !=0) return true;
        String remoteIP = IPUtil.getRemoteIP(request);
        if(StringUtils.isNoneBlank(remoteIP)){
            /*boolean isMatch = pattern.matcher(remoteIP).matches();
            if(!isMatch){
                LOGGER.info("非法IP尝试访问,ip:[{}]",remoteIP);
            }
            return isMatch;*/
            LOGGER.info("来源IP:[{}]",remoteIP);
        }
//        LOGGER.info("未能获取remoteIP");
        return true;
    }

    @Override
    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {

    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {

    }
}
