package cn.quantgroup.xyqb.controller.middleoffice.contact.dto;

import cn.quantgroup.user.enums.BizType;
import cn.quantgroup.xyqb.entity.Contact;
import lombok.Data;
import org.hibernate.validator.constraints.NotEmpty;
import org.springframework.validation.annotation.Validated;

import javax.validation.constraints.NotNull;
import java.util.List;

@Data
@Validated
public class ContactSaveDto {
    @NotNull(message = "用户 ID 不能为空")
    private Long userId;
    @NotNull(message = "业务类型不能为空")
    private BizType bizType;
    @NotEmpty(message = "联系人信息不能为空")
    private List<Contact> contacts;
}
