package cn.quantgroup.xyqb.risk.uereventcollecting;

import cn.qg.ec.kinesis.EnvironmentConfig;
import cn.qg.ec.kinesis.KinesisProducerClient;
import cn.quantgroup.tech.util.TechEnvironment;

/**
 * @author ：dongjianhua
 * @date ：Created in 2020/12/21 16:15
 * @description：client获取
 * @modified By：
 * @version:
 */
public class KinesisProducerClientFactory {
	private KinesisProducerClientFactory() {
	}

	private static class KinesisProducerClientHolder {
		private static final KinesisProducerClient client = new KinesisProducerClient(getConfig());

		private static EnvironmentConfig getConfig() {
			return TechEnvironment.isPro() ? EnvironmentConfig.PROD : EnvironmentConfig.DEV;
		}
	}

	public static KinesisProducerClient getClient() {
		return KinesisProducerClientHolder.client;
	}
}