package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.controller.req.v2.BehaviorRefreshReq;
import cn.quantgroup.xyqb.controller.req.v2.BehaviorReq;
import cn.quantgroup.xyqb.model.BehaviorCodeBean;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.v2.BehaviorContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.Valid;

@RestController
@RequestMapping("/api/v2/behavior")
public class BehaviorApiV2Controller {

    @Autowired
    private BehaviorContext behaviorContext;
    /**
     * 统一获取行为验证码
     * @return JsonResult<SMSCodeBean>
     * @see  <a href="http://yapi.quantgroups.com/project/17/interface/api/65939">统一获取行为验证码</a>
     */
    @PostMapping("/code")
    public JsonResult<BehaviorCodeBean> getCode(@Valid @RequestBody BehaviorReq behaviorReq){
        return JsonResult.buildSuccessResultGeneric(behaviorContext.generate(behaviorReq));
    }

    /**
     * 统一刷新行为验证码
     * @return JsonResult<SMSCodeBean>
     * @see  <a href="http://yapi.quantgroups.com/project/17/interface/api/66059">统一刷新行为验证码</a>
     */
    @PostMapping("/refresh")
    public JsonResult<BehaviorCodeBean> refreshCode(@Valid @RequestBody BehaviorRefreshReq behaviorRefreshReq){
        return JsonResult.buildSuccessResultGeneric(behaviorContext.refresh(behaviorRefreshReq));
    }

}
