package cn.quantgroup.xyqb.filter;


import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import com.alibaba.fastjson.JSONObject;
import org.springframework.util.AntPathMatcher;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by 11 on 2016/12/29.
 */
@WebFilter(urlPatterns = "/*")
@WebInitParam(name = "pathPatterns", value = "/innerapi/**,/user/exist,/user/register,/user/login,/user/register/fast,/user/login/fast,/api/sms/**,/user/reset_password,/user/exist_check,/jr58/**,/app/login,/config/**,/api/**,/user/exists_token")
public class RequestFilter implements Filter {

    private String [] pathPatterns;
    private AntPathMatcher matcher = new AntPathMatcher();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        pathPatterns = filterConfig.getInitParameter("pathPatterns").split(",");
    }

    @Override
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        String requestPath = getRequestPath(request);
        if(isMatch(requestPath)){
            //获取session信息,如果没有获取到session信息则返回错误信息
            SessionStruct sessionStruct = XyqbSessionContextHolder.getXSession();
            if(sessionStruct == null) {
                response.setStatus(200);
                response.
                PrintWriter out = response.getWriter();
                JsonResult result = JsonResult.buildErrorStateResult("登录失败", null);
                out.print(JSONObject.toJSONString(result));
                out.flush();
                out.close();
            }
        }
        filterChain.doFilter(request, response);
    }

    private boolean isMatch(String path) {
        for (String pattern : pathPatterns) {
            if (matcher.match(path, pattern)) {
                return true;
            }
        }
        return false;
    }

    private String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();

        if (request.getPathInfo() != null) {
            url += request.getPathInfo();
        }
        return url;
    }

    @Override
    public void destroy() {

    }
}
