package cn.quantgroup.xyqb.controller;

import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import static cn.quantgroup.xyqb.session.XyqbSessionContextHolder.*;

/**
 * Created by Miraculous on 15/7/5.
 */
public interface IBaseController {

    default User getCurrentUser() {
        SessionStruct session = getXSession();
        if (session == null) {
            return null;
        }
        return getXSession().getValues().getUser();
    }

    default SessionStruct getSessionStruct() {
        return getXSession();
    }


    default Long getChannelId() {
        return getNumber("channelId");
    }

    default Long getCreatedFrom() {
        return getNumber("createdFrom");
    }

    default Long getNumber(String name) {
        SessionStruct session = getSessionStruct();
        try {
            return Long.valueOf(session.getAttribute(name));
        } catch (Exception e) {
            e.getStackTrace();
        }
        return 0L;
    }

    default void setChannelId(Long channelId) {
        SessionStruct session = getSessionStruct();
        if (session != null) {
            session.setAttribute("channleId", channelId.toString());
        }
    }

    default String getAppChannel() {
        SessionStruct session = getSessionStruct();
        String appChannel = session.getAttribute("appChannel");
        if(StringUtils.isEmpty(appChannel)){
            return null;
        }
        return appChannel;
    }


    default HttpServletRequest getRequest() {
        ServletRequestAttributes attrs = (ServletRequestAttributes) RequestContextHolder
                .getRequestAttributes();
        return attrs.getRequest();
    }

    default String getIp() {
        HttpServletRequest request = getRequest();

        String ip = request.getHeader("x-real-ip");
        if (StringUtils.isEmpty(ip)) {
            ip = request.getRemoteAddr();
        }

        //过滤反向代理的ip
        String[] stemps = ip.split(",");
        if (stemps.length >= 1) {
            //得到第一个IP，即客户端真实IP
            ip = stemps[0];
        }

        ip = ip.trim();
        if (ip.length() > 23) {
            ip = ip.substring(0, 23);
        }

        return ip;
    }
}
