package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface IModifyPhoneNoRepository extends JpaRepository<ModifyPhoneNo, Long> {

    @Query(nativeQuery = true, value = "select * from user_modify_phone_no " +
            "where user_id = :userId and (processing_status is null or processing_status <> :processingStatus)" +
            "limit 1")
    ModifyPhoneNo findFirstByUserIdAndProcessingStatusNot(@Param("userId") Long userId,
                                                          @Param("processingStatus") Integer processingStatus);
}
