package cn.quantgroup.user.enums;

import lombok.Getter;

/**
 * 用户手机号修改申请状态
 * <p>
 * Date: 2019/11/5
 * Time: 下午2:11
 *
 * @author: yangrui
 */
@Getter
public enum ModifyPhoneNoApplyStatusEnum {
    /**
     * 处理中
     */
    INIT(0, "处理中"),
    /**
     * 修改完成
     */
    DONE(1, "修改完成"),
    /**
     * 不允许修改
     */
    NO_ALLOW(2, "不允许修改");

    /**
     * 类型
     */
    private int type;

    /**
     * 描述
     */
    private String desc;

    ModifyPhoneNoApplyStatusEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static String getDesc(int type) {
        for (ModifyPhoneNoApplyStatusEnum modifyPhoneNoApplyStatusEnum : ModifyPhoneNoApplyStatusEnum.values()) {
            if (modifyPhoneNoApplyStatusEnum.type == type) {
                return modifyPhoneNoApplyStatusEnum.desc;
            }
        }
        return null;
    }
}
