package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.user.enums.ModifyPhoneNoApplyStatusEnum;
import cn.quantgroup.user.enums.ModifyPhoneNoProcessingStatusEnum;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step1Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step2Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.UserLoanStatusResp;
import cn.quantgroup.xyqb.entity.ModifyPhoneNo;
import cn.quantgroup.xyqb.exception.DataException;
import cn.quantgroup.xyqb.repository.IModifyPhoneNoRepository;
import cn.quantgroup.xyqb.repository.IUserDetailRepository;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import cn.quantgroup.xyqb.service.user.IModifyPhoneNoService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;

/**
 * Date: 2019/11/4
 * Time: 下午2:59
 *
 * @author: yangrui
 */
@Slf4j
@Service
public class ModifyPhoneNoServiceImpl implements IModifyPhoneNoService {

    @Resource
    private IModifyPhoneNoRepository modifyPhoneNoRepository;
    @Resource
    private IUserDetailRepository userDetailRepository;
    @Resource
    private ISmsService smsService;
    @Resource
    private RestTemplate restTemplate;

    @Value("${api.https}")
    public String apiHttps;


    /**
     * @param id       user.id
     * @param step1Req
     * @return
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Long saveStep1(Long id, Step1Req step1Req) {
        // TODO: 2019/11/4 并发访问
        allowModify(id, step1Req.getName(), step1Req.getIdCard(), step1Req.getPrevPhoneNo(), step1Req.getCurPhoneNo(),
                step1Req.getSmsCode());
        ModifyPhoneNo modifyPhoneNo = Step1Req.adapt(step1Req);
        modifyPhoneNo.setUserId(id);
        modifyPhoneNoRepository.saveAndFlush(modifyPhoneNo);
        return modifyPhoneNo.getId();
    }

    /**
     * @param step2Req
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveStep2(Step2Req step2Req) {
        ModifyPhoneNo modifyPhoneNo = modifyPhoneNoRepository.findOne(step2Req.getId());
        modifyPhoneNo.setIdCardFaceUrl(step2Req.getIdCardFaceUrl());
        modifyPhoneNo.setIdCardRearUrl(step2Req.getIdCardRearUrl());
        modifyPhoneNo.setIdCardHoldUrl(step2Req.getIdCardHoldUrl());
        modifyPhoneNo.setApplyStatus(ModifyPhoneNoApplyStatusEnum.INIT.getType());
        modifyPhoneNo.setProcessingStatus(ModifyPhoneNoProcessingStatusEnum.INIT.getType());
    }

    /**
     * 验证用户是否允许修改手机号
     * <p>
     * 校验用户填写的原手机号对应的用户姓名、用户身份证是否和用户中心已有信息一致。若不一致，不允许修改。
     * 新手机号是否在用户中心已存在，若已存在，不允许修改。
     * 用户有审核中和放款中的订单，不允许修改。
     * 用户有还款中的订单，不允许修改。
     * </p>
     *
     * @param id          user.id
     * @param name        注册人真实姓名
     * @param idCard      注册人身份证件号
     * @param prevPhoneNo 当前手机号码
     * @param curPhoneNo  新手机号码
     * @param smsCode     新手机号码短信验证码
     * @return
     */
    public void allowModify(Long id, String name, String idCard, String prevPhoneNo, String curPhoneNo, String smsCode) {
        if (modifyPhoneNoRepository.findFirstByUserIdAndProcessingStatusNot(id, ModifyPhoneNoProcessingStatusEnum.DONE.getType()) != null) {
            throw new DataException("已存在处理中的申请单，不支持再次更换。");
        }
        if (userDetailRepository.findByUserIdAndPhoneNoAndNameAndIdNo(id, prevPhoneNo, name, idCard) == null) {
            throw new DataException("姓名、身份证、电话号不符。");
        }
        if (userDetailRepository.findOneByPhoneNo(curPhoneNo) != null) {
            throw new DataException("新手机号已存在，不支持更换。");
        }
        if (!smsService.verifyPhoneAndCode(curPhoneNo, smsCode)) {
            throw new DataException("验证码不正确。");
        }
        log.info("allowModify userId = 【{}】", id);
        UserLoanStatusResp userLoanStatusResp = restTemplate.getForObject(apiHttps + "?userId=" + id, UserLoanStatusResp.class);
        log.info("allowModify userLoanStatusResp = 【{}】", userLoanStatusResp);
        if (!userLoanStatusResp.isSuccess() || !userLoanStatusResp.isData()) {
            throw new DataException("用户存在订单，不支持修改。");
        }
    }
}
