package cn.quantgroup.xyqb.controller.modifyphoneno;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.AuditReq;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step1Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.req.Step2Req;
import cn.quantgroup.xyqb.controller.modifyphoneno.resp.ModifyPhoneNoResp;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IModifyPhoneNoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;

/**
 * 用户手机号修改相关api
 * <p>
 * Date: 2019/11/4
 * Time: 上午11:23
 *
 * @author: yangrui
 */
@Api(tags = "用户手机号修改相关api")
@RestController
@RequestMapping("/v1/user/modify/phone_no")
public class ModifyPhoneNoController implements IBaseController {

    @Resource
    private IModifyPhoneNoService modifyPhoneNoService;

    /**
     * step_1
     *
     * @param step1Req
     * @return
     */
    @ApiOperation("step_1")
    @PostMapping("/step_1")
    public JsonResult step1(@Valid @RequestBody Step1Req step1Req) {
        User user = getCurrentUserFromRedis();
        if (user == null) {
            return JsonResult.buildErrorStateResult("系统错误", null);
        }
        return JsonResult.buildSuccessResult(modifyPhoneNoService.saveStep1(user.getId(), step1Req));
    }

    /**
     * step_2
     *
     * @param step2Req
     * @return
     */
    @ApiOperation("step_2")
    @PostMapping("/step_2")
    public JsonResult step2(@Valid @RequestBody Step2Req step2Req) {
        modifyPhoneNoService.saveStep2(step2Req);
        return JsonResult.buildSuccessResult();
    }

    /*------------------------------------------------------------------------------------------------------------*/

    /**
     * 后台客服处理功能 - 查询列表
     */
    @ApiOperation("后台客服处理功能 - 查询列表")
    @GetMapping
    public JsonResult<List<ModifyPhoneNoResp>> list() {
        return JsonResult.buildSuccessResult();
    }

    /**
     * 后台客服处理功能 - 人工审核
     */
    @ApiOperation("后台客服处理功能 - 人工审核")
    @PutMapping("/audit")
    public JsonResult audit(AuditReq auditReq) {
        return JsonResult.buildSuccessResult();
    }

    /**
     * 后台客服处理功能 - 反馈跟进
     */
    @ApiOperation("后台客服处理功能 - 反馈跟进")
    @PutMapping("/{id}/feedback")
    public JsonResult feedback(@PathVariable Long id) {
        return JsonResult.buildSuccessResult();
    }
    /*------------------------------------------------------------------------------------------------------------*/
}
