package cn.quantgroup.xyqb.model;

import cn.quantgroup.xyqb.entity.UserDisableRecord;
import java.time.format.DateTimeFormatter;
import lombok.Data;

/**
 * 只是为了兼容时间格式化问题，后续用户中心升级后，该model不需要
 */
@Data
public class UserDisableRecordModel{
  private Long id;
  private Long userId;

  private short operation_type;

  private String reason;

  private String createdBy;

  private String updatedBy;
  private String createdAt;

  private String  updatedAt;

  public static UserDisableRecordModel from(UserDisableRecord userDisableRecord){
    UserDisableRecordModel userDisableRecordModel = new UserDisableRecordModel();
    userDisableRecordModel.setUserId(userDisableRecord.getUserId());
    userDisableRecordModel.setId(userDisableRecord.getId());
    userDisableRecordModel.setReason(userDisableRecord.getReason());
    userDisableRecordModel.setCreatedAt(userDisableRecord.getCreatedAt().toLocalDateTime().format(
        DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    userDisableRecordModel.setUpdatedAt(userDisableRecord.getUpdatedAt().toLocalDateTime().format(
        DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
    userDisableRecordModel.setCreatedBy(userDisableRecord.getCreatedBy());
    userDisableRecordModel.setUpdatedBy(userDisableRecord.getUpdatedBy());
    return userDisableRecordModel;
  }

}
