package cn.quantgroup.xyqb.controller.external.captcha;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.aspect.captcha.CaptchaNewValidator;
import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.service.captcha.IQuantgroupCaptchaService;
import cn.quantgroup.xyqb.util.IPUtil;
import cn.quantgroup.xyqb.util.PasswordUtil;
import cn.quantgroup.xyqb.util.ValidationUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * @author xufei on 2018/1/30.
 */
@Slf4j
@RestController
@RequestMapping("/api")
public class NewCaptchaController {

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;
    @Resource
    private IQuantgroupCaptchaService quantgroupCaptchaService;
    @Value("${geetest.close:false}")
    private String geetestClose;

    @LogHttpCaller
    @RequestMapping(value = "/captcha/new")
    public JsonResult getCaptcha(String phoneNo, String clientType, HttpServletRequest request) {
        String remoteIp = IPUtil.getRemoteIP(request);
        log.info("获取验证码, phoneNo:{}, clientType:{}, ip:{}, verifyType-qg:{}", phoneNo, clientType, remoteIp, geetestClose);
        if (!ValidationUtil.validatePhoneNo(phoneNo)) {
            return JsonResult.buildErrorStateResult("手机号格式错误", null);
        }
        // 数据容器
        Map<String, String> data = new HashMap<String, String>();
        Map<String, String> imgMap = null;
        // 优先获取极验
        if(!Boolean.valueOf(geetestClose)){
            imgMap = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(phoneNo), remoteIp, ClientType.valueByName(clientType));
            data.put(Constants.VERIFY_PARAM, Constants.VERIFY_TYPE_GT);
        }
        // 备选方案：量化派图形验证码
        if(Objects.isNull(imgMap) || imgMap.isEmpty()){
            imgMap = quantgroupCaptchaService.fetchQuantgroupCaptcha(request.getLocale());
            data.put(Constants.VERIFY_PARAM, Constants.VERIFY_TYPE_QG);
        }
        // 返回结果
        if(Objects.isNull(imgMap) || imgMap.isEmpty()){
            return JsonResult.buildErrorStateResult("获取验证码失败", "");
        }
        // 填充数据并返回
        data.putAll(imgMap);
        return JsonResult.buildSuccessResult("", data);
    }

}
