package cn.quantgroup.xyqb.service.user.impl;

import cn.quantgroup.xyqb.entity.UserBtRegister;
import cn.quantgroup.xyqb.repository.IUserBtRegisterRepository;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.persistence.criteria.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * Created by Administrator on 2017/5/16.
 */
@Service
public class UserBtRegisterServiceImpl implements IUserBtRegisterService {
    @Autowired
    private IUserBtRegisterRepository userBtRegisterRepository;

    @Override
//    @Cacheable(value = "btRegisterCache", key = "'userId' + #userId", unless = "#result == null", cacheManager = "cacheManager")
    public UserBtRegister findByUserId(Long userId) {
        if (null != userId) {
            Optional<UserBtRegister> result = userBtRegisterRepository.findOne((root, query, cb) -> {
                List<Predicate> list = new ArrayList<>();
                list.add(cb.equal(root.get("isActive").as(Boolean.class), Boolean.TRUE));
                list.add(cb.equal(root.get("userId").as(Long.class), userId));
                Predicate[] p = new Predicate[list.size()];
                query.where(cb.and(list.toArray(p)));
                return query.getRestriction();
            });
            if(result.isPresent()){
                return result.get();
            }
        }
        return null;
    }

    @Override
    public UserBtRegister save(UserBtRegister userBtRegister) {
        return userBtRegisterRepository.saveAndFlush(userBtRegister);
    }
}
