package cn.quantgroup.xyqb.config.sentry;

import brave.Tracing;
import brave.propagation.TraceContext;
import cn.quantgroup.boot.web.util.TechEnvironment;
import io.sentry.Sentry;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

/**
 * 初始化Sentry配置
 * @author renwc
 * @date 2018-05-22
 */
@Configuration
public class SentryConfig {

    @Value("${dsn}")
    private String dsn;

    @Resource
    private Tracing tracing;
    @Autowired
    private Environment environment;

    @PostConstruct
    public void initSentry() {
        environment.getActiveProfiles();

        if (TechEnvironment.isPro()) {
            Sentry.init(options -> {
                options.setDsn(dsn);
                options.setBeforeSend((event, hint) -> {
                    if (tracing.currentTraceContext() != null) {
                        TraceContext traceContext = tracing.currentTraceContext().get();
                        if (traceContext != null) {
                            event.setTag("tracingId", traceContext.traceIdString());
                            event.setTag("spanId", Long.toHexString(traceContext.spanId()));
                            event.setTag("parentId", traceContext.parentId() == null ? null : Long.toHexString(traceContext.parentId()));
                        }
                    }

                    return event;
                });
            });

        }
    }

}
