package cn.quantgroup.xyqb.config.data;

import cn.quantgroup.xyqb.session.XyqbSessionContextHolder;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.connection.lettuce.LettuceConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

/**
 * Created by Miraculous on 15/7/4.
 */
@Configuration
public class RedisConfig {

    @Value("${xyqb.redis.defaultExpiration}")
    private Long defaultExpiration;
    @Value("${xyqb.redis.master.host}")
    private String masterHost;
    @Value("${xyqb.redis.master.port}")
    private int masterPort;
    @Value("${xyqb.redis.master.name}")
    private String masterName;
    @Value("${xyqb.redis.sentinel1.host}")
    private String sentinel1Host;
    @Value("${xyqb.redis.sentinel1.port}")
    private int sentinel1port;
    @Value("${xyqb.redis.sentinel2.host}")
    private String sentinel2Host;
    @Value("${xyqb.redis.sentinel2.port}")
    private int sentinel2port;
    @Value("${xyqb.redis.sentinel3.host}")
    private String sentinel3Host;
    @Value("${xyqb.redis.sentinel3.port}")
    private int sentinel3port;

    private RedisConnectionFactory generateDevConnectionFactory() {
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration(
            masterHost, masterPort);

        return new LettuceConnectionFactory(config);
    }

    private RedisConnectionFactory generateReleaseConnectionFactory() {
        RedisSentinelConfiguration sentinelConfig = new RedisSentinelConfiguration()
            .master(masterName)
            .sentinel(sentinel1Host, sentinel1port)
            .sentinel(sentinel2Host, sentinel2port)
            .sentinel(sentinel3Host,sentinel3port);
        return new LettuceConnectionFactory(sentinelConfig);
    }

    @Bean(name = "redisConnectionFactory")
    RedisConnectionFactory factory() {
        if (StringUtils.isEmpty(masterName)) {
            return generateDevConnectionFactory();
        } else {
            return generateReleaseConnectionFactory();
        }
    }

    @Bean(name = "redisTemplate")
    public RedisTemplate<String, Object> redisTemplate(
            RedisConnectionFactory factory) {
        final RedisTemplate<String, Object> template = new RedisTemplate<>();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        template.setEnableTransactionSupport(false);
        template.setKeySerializer(stringRedisSerializer);
        template.setHashKeySerializer(stringRedisSerializer);
        template.setValueSerializer(jdkSerializationRedisSerializer);
        template.setDefaultSerializer(jdkSerializationRedisSerializer);
        template.setConnectionFactory(factory);

        XyqbSessionContextHolder.setRedisTemplate(stringRedisTemplate(factory));
        return template;
    }

    @Bean(name = "stringRedisTemplate")
    public RedisTemplate<String, String> stringRedisTemplate(
            RedisConnectionFactory factory) {
        final RedisTemplate<String, String> template = new RedisTemplate<>();
        StringRedisSerializer stringRedisSerializer = new StringRedisSerializer();
        JdkSerializationRedisSerializer jdkSerializationRedisSerializer = new JdkSerializationRedisSerializer();
        template.setEnableTransactionSupport(false);
        template.setKeySerializer(stringRedisSerializer);
        template.setHashKeySerializer(stringRedisSerializer);
        template.setValueSerializer(jdkSerializationRedisSerializer);
        template.setDefaultSerializer(jdkSerializationRedisSerializer);
        template.setConnectionFactory(factory);
        return template;
    }

}
