package login;

import cn.quantgroup.xyqb.Bootstrap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.SpringApplicationConfiguration;
import org.springframework.http.MediaType;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

import java.nio.charset.Charset;
import java.util.Base64;

import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.status;

@RunWith(SpringJUnit4ClassRunner.class)
@SpringApplicationConfiguration(classes = Bootstrap.class)
@WebAppConfiguration
public class LoginWithTokenOnceTests {
  final String phoneNo = "13461067662";
  final String userName = "root";
  final String password = "！QAZ2wsx";

  private MockMvc mvc;
  @Autowired
  WebApplicationContext webApplicationConnect;

  @Before
  public void setUp() throws JsonProcessingException {
    mvc = MockMvcBuilders.webAppContextSetup(webApplicationConnect).build();

  }

  /**
   * 测试Server是否可达
   * @throws Exception
   */
  @Test
  public void testServer() throws Exception {
    mvc.perform(MockMvcRequestBuilders.get("/").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
    mvc.perform(MockMvcRequestBuilders.get("/user/loginForH5").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
    mvc.perform(MockMvcRequestBuilders.get("/user/login/fastForH5").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
    mvc.perform(MockMvcRequestBuilders.get("/api/sms/send_login_code").accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk());
  }

  /**
   * 测试TokenOnce发放服务
   * @throws Exception
   */
  @Test
  public void testLoginFoH5() throws Exception{
    // 获取TokenOnce
    String tokenOnceUri = "/token/once";
    MvcResult mvcResult = mvc.perform(MockMvcRequestBuilders.get(tokenOnceUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", phoneNo))
            .andExpect(status().isOk())
            .andReturn();
    String content = mvcResult.getResponse().getContentAsString();
    JSONObject jsonResult = JSON.parseObject(new String(content));
    Object code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    Object data = jsonResult.get("data");
    Assert.assertNotNull(data);
    StringBuilder tokenBuilder = new StringBuilder(phoneNo);
    String tokenOnce = new String(Base64.getEncoder().encodeToString(tokenBuilder.append(":").append(data).toString().getBytes(Charset.forName("UTF-8"))));
    StringBuilder basicBuilder = new StringBuilder();
    String authorization = "Basic " + new String(Base64.getEncoder().encodeToString(basicBuilder.append(userName).append(":").append(password).toString().getBytes(Charset.forName("UTF-8"))));
    // 第一次使用TokenOnce
    String aspectUri = "/user/loginForH5";
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .header("TokenOnce", tokenOnce)
            .header("authorization", authorization)
            .param("openId", "none"))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Object businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0000", code);
    Assert.assertNotEquals("0002", businessCode);
    // 使用过期的TokenOnce
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .header("TokenOnce", tokenOnce)
            .header("authorization", authorization)
            .param("openId", "none"))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
    // 不使用TokenOnce
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .header("authorization", authorization)
            .param("openId", "none"))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
  }

  /**
   * 测试TokenOnce切面
   * @throws Exception
   */
  @Test
  public void testLoginFastFoH5() throws Exception{
    // 获取TokenOnce
    String tokenOnceUri = "/token/once";
    MvcResult mvcResult = mvc.perform(MockMvcRequestBuilders.get(tokenOnceUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", phoneNo))
            .andExpect(status().isOk())
            .andReturn();
    String content = mvcResult.getResponse().getContentAsString();
    JSONObject jsonResult = JSON.parseObject(new String(content));
    Object code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    Object data = jsonResult.get("data");
    Assert.assertNotNull(data);
    StringBuilder tokenBuilder = new StringBuilder(phoneNo);
    String tokenOnce = new String(Base64.getEncoder().encodeToString(tokenBuilder.append(":").append(data).toString().getBytes(Charset.forName("UTF-8"))));

    String smsUri = "/api/sms/send_login_code";
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(tokenOnceUri).accept(MediaType.APPLICATION_JSON)
            .param("phoneNo", phoneNo))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    data = jsonResult.get("data");
    Assert.assertNotNull(data);
    String verificationCode = "1234";
    StringBuilder verificationBuilder = new StringBuilder();
    String authorization = "Verification " + new String(Base64.getEncoder().encodeToString(verificationBuilder.append(phoneNo).append(":").append(verificationCode).toString().getBytes(Charset.forName("UTF-8"))));
    // 第一次使用TokenOnce
    String aspectUri = "/user/login/fastForH5";
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .header("TokenOnce", tokenOnce)
            .header("authorization", authorization))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Object businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0000", code);
    Assert.assertNotEquals("0001", businessCode);
    // 使用过期的TokenOnce与verificationCode
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON)
            .header("TokenOnce", tokenOnce)
            .header("authorization", authorization))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
    // 不使用TokenOnce和verificationCode
    mvcResult = mvc.perform(MockMvcRequestBuilders.get(aspectUri).accept(MediaType.APPLICATION_JSON))
            .andExpect(status().isOk())
            .andReturn();
    content = mvcResult.getResponse().getContentAsString();
    jsonResult = JSON.parseObject(new String(content));
    code = jsonResult.get("code");
    Assert.assertEquals("0000", code);
    businessCode = jsonResult.get("businessCode");
    Assert.assertEquals("0002", businessCode);
  }

}
