package cn.quantgroup.xyqb.controller.internal.login;

import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserRet;
import cn.quantgroup.xyqb.model.session.LoginInfo;
import cn.quantgroup.xyqb.model.session.SessionStruct;
import cn.quantgroup.xyqb.service.http.IHttpService;
import cn.quantgroup.xyqb.service.user.IUserBtRegisterService;
import cn.quantgroup.xyqb.service.user.IUserService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by Miraculous on 2016/12/30.
 */
@RestController
@RequestMapping("/auth")
@Slf4j
public class AuthInfoController implements IBaseController {

  @Autowired
  private IHttpService httpService;

  @Autowired
  private IUserService userService;

  @Autowired
  private IUserBtRegisterService userBtRegisterService;


  @RequestMapping("/info/login")
  public JsonResult loginInfo() {
    SessionStruct sessionStruct = getCurrentSessionFromRedis();
    if(null != sessionStruct) {
      log.info("从用户中心获取到了用户登录信息:phone:[{}]", sessionStruct.getValues().getUser().getPhoneNo());
      LoginInfo loginInfo = new LoginInfo();
      loginInfo.setUser(new UserRet(sessionStruct.getValues().getUser()));
      loginInfo.setToken(sessionStruct.getSid());
      LoginInfo.LoginContext context = new LoginInfo.LoginContext();
      context.setChannelId(sessionStruct.getValues().getLoginProperties().getChannelId());
      context.setCreatedFrom(sessionStruct.getValues().getLoginProperties().getCreatedFrom());
      context.setAppChannel(sessionStruct.getValues().getLoginProperties().getAppChannel());
      context.setBtMerchantId(sessionStruct.getValues().getLoginProperties().getBtMerchantId());
      //有ThreadLocal不释放的问题，不可再使用原来方式了
      loginInfo.setLoginContext(context);
      return JsonResult.buildSuccessResult("", loginInfo);
    }
    return JsonResult.buildErrorStateResult("用户未登录",null);
  }

}
