package cn.quantgroup.xyqb.service.sms.impl;

import cn.quantgroup.sms.SendAndForgetMsg;
import cn.quantgroup.sms.SmsSender;
import cn.quantgroup.xyqb.service.sms.ISmsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.Collections;

/**
 * @author mengfan.feng
 * @time 2015-07-25 18:47
 */
@Service
public class SmsServiceImpl implements ISmsService {

    private static final Logger LOGGER = LoggerFactory.getLogger(SmsServiceImpl.class);

    @Value("${sms.is.debug}")
    private boolean isDebug;

    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    private SmsSender smsSender = null;

    @Override
    public SmsSender getSmsSender() {
        if (null == smsSender) {
            smsSender = new SmsSender();
        }
        return this.smsSender;
    }

    @Override
    public void sendAfterRegister(String phoneNo) {
        try {
            smsSender.sendAndForget(new SendAndForgetMsg(Collections.emptyList(), "24", "1", phoneNo));
            LOGGER.info("注册完成，发送短信, phoneNo:{}", phoneNo);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
