package cn.quantgroup.xyqb.event.jr58;

import cn.quantgroup.xyqb.service.http.IHttpService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class Jr58DataSender {

    private static final Logger LOGGER = LoggerFactory.getLogger(Jr58DataSender.class);

    @Autowired
    private Jr58MessageSigner jr58MessageSigner;

    @Autowired
    private IHttpService httpService;

    @Value("${jr58.notify.userinfo}")
    private String jr58nNotifyUserinfo;

    /**
     * 向58金融同步用户信息
     *
     * @param uuid
     */
    @Async
    public void sendUserinfo(String uuid) {
        try {
            JsonObject json = new JsonObject();
            json.addProperty("salaryWay", 0);
            json.addProperty("loanPurpose", "12");
            json.addProperty("job", 0);
            json.addProperty("account", 1000);
            json.addProperty("salary", 0);
            json.addProperty("hourse", 1);
            json.addProperty("isShebao", 0);
            json.addProperty("education", "");
            json.addProperty("isCreditCard", "0");
            json.addProperty("isOtherLoanOrg", "0");

            String userinfo = json.toString();
            String param = uuid + "|1|" + userinfo;
            String sign = jr58MessageSigner.sign(param);

            Map<String, String> parameters = ImmutableMap.<String, String>builder()
                    .put("customerId", uuid)
                    .put("authorState", "100")
                    .put("baseFlag", "1")
                    .put("userinfo", userinfo)
                    .put("sign", sign)
                    .build();

            httpService.post(jr58nNotifyUserinfo, parameters);

        } catch (Exception e) {
            LOGGER.error("向58金融同步用户信息", e);
        }
    }
}
