package cn.quantgroup.xyqb.controller.middleoffice.userext;

import cn.quantgroup.xyqb.constant.enums.OccupationEnum;
import cn.quantgroup.xyqb.controller.middleoffice.userext.req.UserExtReq;
import cn.quantgroup.xyqb.entity.User;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.service.user.IUserDetailService;
import cn.quantgroup.xyqb.service.user.IUserService;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * 用户扩展信息
 */
@RestController
@RequestMapping("/middle_office/user/ext")
public class UserExtController {

    @Resource
    private IUserDetailService userDetailService;


    @Resource
    private IUserService userService;

    @Resource
    private ApplicationEventPublisher applicationEventPublisher;

    //todo 保存失败的各种场景。
    @PutMapping("/{userId}")
    public JsonResult ext(@PathVariable Long userId, @RequestBody UserExtReq userExtReq) {
        if (userExtReq.getEmail() != null) {
            userDetailService.updateUserEmail(userId, userExtReq.getEmail());
        }
        if (userExtReq.getQq() != null) {
            userDetailService.updateUserQq(userId, userExtReq.getQq());
        }
        return JsonResult.buildSuccessResult();
    }


}
