package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.ClientType;
import cn.quantgroup.xyqb.service.captcha.IGeetestCaptchaService;
import cn.quantgroup.xyqb.util.PasswordUtil;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

import javax.annotation.Resource;
import java.util.Map;

@RunWith(SpringRunner.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class GeetestCaptchaServiceTest {

    @Resource
    private IGeetestCaptchaService geetestCaptchaService;

    private String phoneNo = "18010043006";
    private String remoteIp = "127.0.0.1";
    private ClientType clientType = ClientType.H5;
    private Map<String, String> data = null;

    @Test
    public void testFetchGeetestCaptcha(){
        data = geetestCaptchaService.fetchGeetestCaptcha(PasswordUtil.MD5(phoneNo), remoteIp, clientType);
        Assert.assertNotNull(data);
    }


    @Test
    public void testValidGeetestCaptcha(){
        String challenge = "d6e965e06b187c0a01276834d2ff00e6";
        String validate = "validate";
        String seccode = "seccode";
        Assert.assertTrue(geetestCaptchaService.validGeetestCaptcha(PasswordUtil.MD5(phoneNo), remoteIp, clientType, challenge, validate, seccode));
    }
}
