package cn.quantgroup.xyqb.controller.internal.user;

import cn.quantgroup.xyqb.aspect.logcaller.LogHttpCaller;
import cn.quantgroup.xyqb.entity.UserAuthorized;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author xufei on 2018/1/5.
 */
@RestController
@RequestMapping("/user/auth")
public class UserAuthorizedController {

    private static final Logger LOGGER = LoggerFactory.getLogger(UserAuthorizedController.class);

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    @LogHttpCaller
    @RequestMapping(value = "/hasUserAuthorized")
    public JsonResult hasUserAuthorized(String idNo) {
        LOGGER.info("[hasUserAuthorized]需要校验的用户的身份证号为idNo:{}", idNo);
        if (userAuthorizedService.hasUserAuthorized(idNo)) {
            return JsonResult.buildSuccessResult(null, true);
        } else {
            return JsonResult.buildErrorStateResult(null, false);
        }
    }

    @LogHttpCaller
    @RequestMapping(value = "/createUserAuthorized")
    public JsonResult createUserAuthorized(UserAuthorizedParam userAuthorizedParam) {
        LOGGER.info("[createUserAuthorized]创建实名账户,userAuthorizedParam:{},", userAuthorizedParam);
        try {
            if (userAuthorizedService.checkUserAuthorizedParam(userAuthorizedParam)) {
                return JsonResult.buildErrorStateResult("参数异常", null);
            }
        } catch (Exception e) {
            LOGGER.info("[createUserAuthorized]创建实名账户失败e:{}", e);
            return JsonResult.buildErrorStateResult("参数异常", null);
        }
        UserAuthorized userAuthorized = userAuthorizedService.createUserAuthorized(userAuthorizedParam);
        if (null == userAuthorized) {
            return JsonResult.buildErrorStateResult("重复创建异常", null);
        } else {
            return JsonResult.buildSuccessResult("创建成功", userAuthorized.getId());
        }
    }

    @LogHttpCaller
    @RequestMapping(value = "/getUserAuthorizedId")
    public JsonResult getUserAuthorizedId(String userUuid) {
        LOGGER.info("[getUserAuthorizedId]获取实名账户的id，userUuid:{}", userUuid);
        return JsonResult.buildSuccessResult(null, userAuthorizedService.getUserAuthorizedId(userUuid));
    }
}
