package cn.quantgroup.xyqb.repository;

import cn.quantgroup.xyqb.entity.UserDetail;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * @author mengfan.feng
 * @time 2015-09-11 11:22
 */
public interface IUserDetailRepository extends JpaRepository<UserDetail, Long>,JpaSpecificationExecutor<UserDetail> {

  UserDetail findByUserId(Long userId);

  UserDetail findByPhoneNo(String phone);

  @Transactional
  @Modifying
  @Query(value = "update user_detail set qq = ?1 where user_id = ?2", nativeQuery = true)
  void updateUserQQ(String qq, Long userId);

  @Transactional
  @Modifying
  @Query(value = "update user_detail set gender = ?1 where user_id = ?2", nativeQuery = true)
  void updateGender( int gender, Long userId);

  List<UserDetail> findAll(Specification<UserDetail> specification);

  /**
   * 修复线上身份证问题，后续误用
   * @return
   */
  @Modifying
  @Query(value = "select * from user_detail where gender!=1 and gender!=2 and id_no is not null", nativeQuery = true)
  List<UserDetail> selectUserDetailsBy();
}
