package service;

import cn.quantgroup.xyqb.Bootstrap;
import cn.quantgroup.xyqb.model.AuthPattern;
import cn.quantgroup.xyqb.model.UserAuthorizedParam;
import cn.quantgroup.xyqb.service.auth.IUserAuthorizedService;
import com.ctrip.framework.apollo.spring.config.ApolloPropertySourceInitializer;
import demo.BaseParametersTests;
import lombok.extern.slf4j.Slf4j;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;

/**
 * 业务层测试用例
 * @author renwc
 * @date 2018-01-05
 */
@Slf4j
@Rollback
@Transactional
@RunWith(value = Parameterized.class)
@SpringBootTest(classes = Bootstrap.class)
@ContextConfiguration(initializers = ApolloPropertySourceInitializer.class)
public class UserAuthorizedServiceTests extends BaseParametersTests {

    @Resource
    private IUserAuthorizedService userAuthorizedService;

    UserAuthorizedParam obj = new UserAuthorizedParam();
    public UserAuthorizedServiceTests(Long userId, String idNo, String name, AuthPattern authPattern, Boolean available) {
        obj.setUserId(userId);
        obj.setIdNo(idNo);
        obj.setName(name);
        obj.setAuthPattern(Optional.ofNullable(authPattern).orElse(AuthPattern.ZMXY).name());
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{
                {1L,"350504198805144101","史书一", AuthPattern.ZMXY, true},
                {10L,"350504198805144102","史书二", AuthPattern.ZMXY, true},
                {20L,"350504198805144103","史书三", AuthPattern.FOUR_ELEMENTS_OF_BANK_CARD, true},
                {1L, "IDNO-1", "王-1", AuthPattern.ZMXY, true}
        };
        return Arrays.asList(data);
    }

    @Test
    public void testExist() throws Exception {
        log.info("testExist: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        Object obj = userAuthorizedService.hasUserAuthorized(this.obj.getIdNo());
        Assert.assertNotNull(obj);
    }

    @Test
    public void testSave() throws Exception {
        log.info("testSave: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        Object obj = userAuthorizedService.createUserAuthorized(this.obj);
        Assert.assertNotNull(obj);
    }

    @Test
    public void testQuery(){
        log.info("testQuery: name:{}, idNo:{}, userId:{}, authPattern:{}", obj.getName(), obj.getIdNo(), obj.getUserId(), obj.getAuthPattern());
        Object obj = userAuthorizedService.getUserAuthorizedId(this.obj.getUserId());
        Assert.assertNotNull(obj);
    }

}
