package cn.quantgroup.xyqb.controller.api.v2;

import cn.quantgroup.xyqb.Constants;
import cn.quantgroup.xyqb.controller.IBaseController;
import cn.quantgroup.xyqb.controller.req.v2.UserInfoEntityReq;
import cn.quantgroup.xyqb.entity.UserInfoEntity;
import cn.quantgroup.xyqb.exception.BizExceptionEnum;
import cn.quantgroup.xyqb.model.JsonResult;
import cn.quantgroup.xyqb.model.webchat.AccessTokenResponse;
import cn.quantgroup.xyqb.repository.IUserInfoRepository;
import cn.quantgroup.xyqb.util.DateUtils;
import com.alibaba.fastjson.JSON;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaUpdate;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

@RestController
@RequestMapping("/api/v2/user-entity")
public class UserInfoEntityApiV2Controller implements IBaseController {
    @Autowired
    @Qualifier("stringRedisTemplate")
    private RedisTemplate<String, String> redisTemplate;

    @Autowired
    private IUserInfoRepository userInfoRepository;
    @PersistenceContext
    private EntityManager entityManager;


    @PostMapping("/edit")
    //@Transactional(rollbackFor = Exception.class)
    @Transactional
    public JsonResult<UserInfoEntity> token(@RequestBody UserInfoEntityReq req) {

        if (!UserInfoEntityReq.checkParam(req)) {
            return JsonResult.buildErrorStateResult(BizExceptionEnum.ERROR_PARAM.getMsg(), null);
        }

        Integer tenantId = getTenantId();

        // Create a query to select the entities that match the condition
        CriteriaBuilder criteriaBuilder = entityManager.getCriteriaBuilder();
        CriteriaUpdate<UserInfoEntity> updateQuery = criteriaBuilder.createCriteriaUpdate(UserInfoEntity.class);
        Root<UserInfoEntity> root = updateQuery.from(UserInfoEntity.class);

        UserInfoEntity userInfoEntity = userInfoRepository.findByUserIdAndTenantId(req.getUserId(), tenantId);
        if (userInfoEntity == null) {
            userInfoEntity = new UserInfoEntity();
            userInfoEntity.setTenantId(tenantId);
            userInfoEntity.setUserId(req.getUserId());

        }

        //如果是空串，表示去掉相关信息
        if (req.getGender() != null) {
            updateQuery.set(root.get("gender"), req.getGender());
            userInfoEntity.setGender(req.getGender());
        }
        if (req.getEmail() != null) {
            updateQuery.set(root.get("email"), req.getEmail());
            userInfoEntity.setEmail(req.getEmail());
        }
        if (req.getBirthday() != null) {
            updateQuery.set(root.get("birthday"), req.getBirthday());
            userInfoEntity.setBirthday(DateUtils.parse2LocalDate(req.getBirthday()));
        }
        if (req.getName() != null) {
            updateQuery.set(root.get("name"), req.getName());
            userInfoEntity.setName(req.getName());
        }
        if (req.getNickName() != null) {
            updateQuery.set(root.get("nickName"), req.getNickName());
            userInfoEntity.setNickName(req.getNickName());
        }
        if (req.getPhoto() != null) {
            updateQuery.set(root.get("photo"), req.getPhoto());
            userInfoEntity.setPhoto(req.getPhoto());
        }
        if (req.getQq() != null) {
            updateQuery.set(root.get("qq"), req.getQq());
            userInfoEntity.setQq(req.getQq());
        }

        //插入操作
        if (userInfoEntity.getId() == null) {
            userInfoRepository.saveAndFlush(userInfoEntity);
            return JsonResult.buildSuccessResultGeneric(userInfoEntity);
        }

        // Set the condition for the update
        Predicate condition = criteriaBuilder.equal(root.get("userId"), req.getUserId());
        Predicate condition2 = criteriaBuilder.equal(root.get("tenantId"), tenantId);
        updateQuery.where(condition,condition2);

        //更新操作
        int i = entityManager.createQuery(updateQuery).executeUpdate();


        UserInfoEntity userInfoEntityNew = userInfoRepository.findByUserIdAndTenantId(req.getUserId(), tenantId);
        return JsonResult.buildSuccessResultGeneric(userInfoEntityNew);
    }
}
